/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.AbstractAnnotationTypeQualifierResolver;
import kotlin.reflect.jvm.internal.impl.load.java.JavaTypeEnhancementState;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;

public final class AnnotationTypeQualifierResolver
extends AbstractAnnotationTypeQualifierResolver {
    public AnnotationTypeQualifierResolver(JavaTypeEnhancementState javaTypeEnhancementState) {
        Intrinsics.checkNotNullParameter(javaTypeEnhancementState, "javaTypeEnhancementState");
        super(javaTypeEnhancementState);
    }

    private final List toEnumNames(ConstantValue object) {
        if (object instanceof ArrayValue) {
            ArrayList arrayList;
            Iterable iterable = (Iterable)((ArrayValue)object).getValue();
            object = arrayList;
            arrayList = new ArrayList();
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                CollectionsKt.addAll((Collection)object, this.toEnumNames((ConstantValue)iterator2.next()));
            }
        } else {
            object = object instanceof EnumValue ? CollectionsKt.listOf((Object)((EnumValue)object).getEnumEntryName().getIdentifier()) : CollectionsKt.emptyList();
        }
        return object;
    }

    protected Iterable getMetaAnnotations(AnnotationDescriptor annotationDescriptor) {
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        Intrinsics.checkNotNullParameter(annotationDescriptor2, "<this>");
        Object object = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor2);
        if (object == null || (object = object.getAnnotations()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    protected Object getKey(AnnotationDescriptor annotationDescriptor) {
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        Intrinsics.checkNotNullParameter(annotationDescriptor2, "<this>");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor2);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    protected FqName getFqName(AnnotationDescriptor annotationDescriptor) {
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        Intrinsics.checkNotNullParameter(annotationDescriptor2, "<this>");
        return annotationDescriptor2.getFqName();
    }

    protected Iterable enumArguments(AnnotationDescriptor object, boolean bl) {
        ArrayList arrayList;
        AnnotationDescriptor annotationDescriptor = object;
        Intrinsics.checkNotNullParameter(annotationDescriptor, "<this>");
        object = arrayList;
        arrayList = new ArrayList();
        for (Map.Entry entry : annotationDescriptor.getAllValueArguments().entrySet()) {
            Object object2 = (Name)entry.getKey();
            ConstantValue constantValue = (ConstantValue)entry.getValue();
            object2 = bl && !Intrinsics.areEqual(object2, JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME) ? CollectionsKt.emptyList() : this.toEnumNames(constantValue);
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
        }
        return object;
    }
}

