/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap$PlatformMutabilityMapping;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.name.StandardClassIds;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;

public final class JavaToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE;
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final ClassId K_CLASS_CLASS_ID;
    private static final ClassId CLASS_CLASS_ID;
    private static final HashMap javaToKotlin;
    private static final HashMap kotlinToJava;
    private static final HashMap mutableToReadOnly;
    private static final HashMap readOnlyToMutable;
    private static final HashMap mutableToReadOnlyClassId;
    private static final HashMap readOnlyToMutableClassId;
    private static final List mutabilityMappings;

    private JavaToKotlinClassMap() {
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe fqNameUnsafe, String string) {
        String string2 = fqNameUnsafe.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "kotlinFqName.asString()");
        Object object = StringsKt.substringAfter(string2, string, "");
        if (object.length() > 0 && !StringsKt.startsWith$default((CharSequence)object, '0', false, 2, null)) {
            return (object = StringsKt.toIntOrNull((String)object)) != null && (Integer)object >= 23;
        }
        return false;
    }

    private final void addMapping(JavaToKotlinClassMap$PlatformMutabilityMapping object) {
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping = object;
        object = javaToKotlinClassMap$PlatformMutabilityMapping.component1();
        ClassId classId = javaToKotlinClassMap$PlatformMutabilityMapping.component2();
        ClassId classId2 = javaToKotlinClassMap$PlatformMutabilityMapping.component3();
        ((JavaToKotlinClassMap)((Object)fqName3)).add((ClassId)object, classId);
        FqName fqName2 = classId2.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "mutableClassId.asSingleFqName()");
        ((JavaToKotlinClassMap)((Object)fqName3)).addKotlinToJava(fqName2, (ClassId)object);
        mutableToReadOnlyClassId.put(classId2, classId);
        readOnlyToMutableClassId.put(classId, classId2);
        FqName fqName3 = classId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName3, "readOnlyClassId.asSingleFqName()");
        object = classId2.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(object, "mutableClassId.asSingleFqName()");
        FqNameUnsafe fqNameUnsafe = classId2.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "mutableClassId.asSingleFqName().toUnsafe()");
        mutableToReadOnly.put(fqNameUnsafe, fqName3);
        FqNameUnsafe fqNameUnsafe2 = fqName3.toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe2, "readOnlyFqName.toUnsafe()");
        readOnlyToMutable.put(fqNameUnsafe2, object);
    }

    private final void add(ClassId classId, ClassId classId2) {
        JavaToKotlinClassMap javaToKotlinClassMap = fqName2;
        ((JavaToKotlinClassMap)((Object)fqName2)).addJavaToKotlin(classId, classId2);
        FqName fqName2 = classId2.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinClassId.asSingleFqName()");
        javaToKotlinClassMap.addKotlinToJava(fqName2, classId);
    }

    private final void addTopLevel(Class clazz, FqNameUnsafe fqNameUnsafe) {
        JavaToKotlinClassMap javaToKotlinClassMap = fqName2;
        FqName fqName2 = fqNameUnsafe.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinFqName.toSafe()");
        javaToKotlinClassMap.addTopLevel(clazz, fqName2);
    }

    private final void addTopLevel(Class object, FqName fqName2) {
        JavaToKotlinClassMap javaToKotlinClassMap = classId;
        ClassId classId = ((JavaToKotlinClassMap)((Object)classId)).classId((Class)object);
        object = ClassId.topLevel(fqName2);
        Intrinsics.checkNotNullExpressionValue(object, "topLevel(kotlinFqName)");
        javaToKotlinClassMap.add(classId, (ClassId)object);
    }

    private final void addJavaToKotlin(ClassId classId, ClassId classId2) {
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "javaClassId.asSingleFqName().toUnsafe()");
        javaToKotlin.put(fqNameUnsafe, classId2);
    }

    private final void addKotlinToJava(FqName fqName2, ClassId classId) {
        FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "kotlinFqNameUnsafe.toUnsafe()");
        kotlinToJava.put(fqNameUnsafe, classId);
    }

    private final ClassId classId(Class clazz) {
        Object object;
        boolean bl = !clazz.isPrimitive() && !clazz.isArray();
        if (_Assertions.ENABLED && !bl) {
            object = "Invalid class: " + clazz;
            throw new AssertionError(object);
        }
        Class<?> clazz2 = clazz.getDeclaringClass();
        if (clazz2 == null) {
            object = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            Intrinsics.checkNotNullExpressionValue(object, "topLevel(FqName(clazz.canonicalName))");
        } else {
            object = ((JavaToKotlinClassMap)object).classId(clazz2).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            Intrinsics.checkNotNullExpressionValue(object, "classId(outer).createNes\u2026tifier(clazz.simpleName))");
        }
        return object;
    }

    static {
        int n;
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping;
        ClassId classId;
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping2;
        ClassId classId2;
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping3;
        ClassId classId3;
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping4;
        ClassId classId4;
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping5;
        ClassId classId5;
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping6;
        ClassId classId6;
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping7;
        ClassId classId7;
        JavaToKotlinClassMap$PlatformMutabilityMapping javaToKotlinClassMap$PlatformMutabilityMapping8;
        ClassId classId8;
        JavaToKotlinClassMap javaToKotlinClassMap;
        Object object = javaToKotlinClassMap;
        INSTANCE = new JavaToKotlinClassMap();
        Object object2 = FunctionClassKind.Function;
        NUMBERED_FUNCTION_PREFIX = ((FunctionClassKind)((Object)object2)).getPackageFqName().toString() + '.' + ((FunctionClassKind)((Object)object2)).getClassNamePrefix();
        object2 = FunctionClassKind.KFunction;
        NUMBERED_K_FUNCTION_PREFIX = ((FunctionClassKind)((Object)object2)).getPackageFqName().toString() + '.' + ((FunctionClassKind)((Object)object2)).getClassNamePrefix();
        object2 = FunctionClassKind.SuspendFunction;
        NUMBERED_SUSPEND_FUNCTION_PREFIX = ((FunctionClassKind)((Object)object2)).getPackageFqName().toString() + '.' + ((FunctionClassKind)((Object)object2)).getClassNamePrefix();
        object2 = FunctionClassKind.KSuspendFunction;
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = ((FunctionClassKind)((Object)object2)).getPackageFqName().toString() + '.' + ((FunctionClassKind)((Object)object2)).getClassNamePrefix();
        ClassId classId9 = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkNotNullExpressionValue(classId9, "topLevel(FqName(\"kotlin.jvm.functions.FunctionN\"))");
        FUNCTION_N_CLASS_ID = classId9;
        FqName fqName2 = classId9.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "FUNCTION_N_CLASS_ID.asSingleFqName()");
        FUNCTION_N_FQ_NAME = fqName2;
        StandardClassIds standardClassIds = StandardClassIds.INSTANCE;
        K_FUNCTION_CLASS_ID = standardClassIds.getKFunction();
        K_CLASS_CLASS_ID = standardClassIds.getKClass();
        CLASS_CLASS_ID = ((JavaToKotlinClassMap)object).classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        mutableToReadOnlyClassId = new HashMap();
        readOnlyToMutableClassId = new HashMap();
        Object[] objectArray = new JavaToKotlinClassMap$PlatformMutabilityMapping[8];
        object2 = ClassId.topLevel(StandardNames$FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue(object2, "topLevel(FqNames.iterable)");
        Object object3 = StandardNames$FqNames.mutableIterable;
        Object object4 = classId8;
        FqName fqName3 = object3;
        Object object5 = object2;
        object3 = ((ClassId)object5).getPackageFqName();
        FqName fqName4 = ((ClassId)object5).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName4, "kotlinReadOnly.packageFqName");
        classId8 = new ClassId((FqName)object3, FqNamesUtilKt.tail(fqName3, fqName4), false);
        object3 = javaToKotlinClassMap$PlatformMutabilityMapping8;
        javaToKotlinClassMap$PlatformMutabilityMapping8 = new JavaToKotlinClassMap$PlatformMutabilityMapping(((JavaToKotlinClassMap)object).classId(Iterable.class), (ClassId)object2, (ClassId)object4);
        objectArray[0] = object3;
        object2 = ClassId.topLevel(StandardNames$FqNames.iterator);
        Intrinsics.checkNotNullExpressionValue(object2, "topLevel(FqNames.iterator)");
        object3 = StandardNames$FqNames.mutableIterator;
        object4 = classId7;
        Object object6 = object3;
        Object object7 = object2;
        object3 = ((ClassId)object7).getPackageFqName();
        FqName fqName5 = ((ClassId)object7).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName5, "kotlinReadOnly.packageFqName");
        classId7 = new ClassId((FqName)object3, FqNamesUtilKt.tail((FqName)object6, fqName5), false);
        object3 = javaToKotlinClassMap$PlatformMutabilityMapping7;
        javaToKotlinClassMap$PlatformMutabilityMapping7 = new JavaToKotlinClassMap$PlatformMutabilityMapping(((JavaToKotlinClassMap)object).classId(Iterator.class), (ClassId)object2, (ClassId)object4);
        objectArray[1] = object3;
        object2 = ClassId.topLevel(StandardNames$FqNames.collection);
        Intrinsics.checkNotNullExpressionValue(object2, "topLevel(FqNames.collection)");
        object3 = StandardNames$FqNames.mutableCollection;
        object4 = classId6;
        Object object8 = object3;
        Object object9 = object2;
        object3 = ((ClassId)object9).getPackageFqName();
        FqName fqName6 = ((ClassId)object9).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName6, "kotlinReadOnly.packageFqName");
        classId6 = new ClassId((FqName)object3, FqNamesUtilKt.tail((FqName)object8, fqName6), false);
        object3 = javaToKotlinClassMap$PlatformMutabilityMapping6;
        javaToKotlinClassMap$PlatformMutabilityMapping6 = new JavaToKotlinClassMap$PlatformMutabilityMapping(((JavaToKotlinClassMap)object).classId(Collection.class), (ClassId)object2, (ClassId)object4);
        objectArray[2] = object3;
        object2 = ClassId.topLevel(StandardNames$FqNames.list);
        Intrinsics.checkNotNullExpressionValue(object2, "topLevel(FqNames.list)");
        object3 = StandardNames$FqNames.mutableList;
        object4 = classId5;
        Object object10 = object3;
        Object object11 = object2;
        object3 = ((ClassId)object11).getPackageFqName();
        FqName fqName7 = ((ClassId)object11).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName7, "kotlinReadOnly.packageFqName");
        classId5 = new ClassId((FqName)object3, FqNamesUtilKt.tail((FqName)object10, fqName7), false);
        object3 = javaToKotlinClassMap$PlatformMutabilityMapping5;
        javaToKotlinClassMap$PlatformMutabilityMapping5 = new JavaToKotlinClassMap$PlatformMutabilityMapping(((JavaToKotlinClassMap)object).classId(List.class), (ClassId)object2, (ClassId)object4);
        objectArray[3] = object3;
        object2 = ClassId.topLevel(StandardNames$FqNames.set);
        Intrinsics.checkNotNullExpressionValue(object2, "topLevel(FqNames.set)");
        object3 = StandardNames$FqNames.mutableSet;
        object4 = classId4;
        Object object12 = object3;
        Object object13 = object2;
        object3 = ((ClassId)object13).getPackageFqName();
        FqName fqName8 = ((ClassId)object13).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName8, "kotlinReadOnly.packageFqName");
        classId4 = new ClassId((FqName)object3, FqNamesUtilKt.tail((FqName)object12, fqName8), false);
        object3 = javaToKotlinClassMap$PlatformMutabilityMapping4;
        javaToKotlinClassMap$PlatformMutabilityMapping4 = new JavaToKotlinClassMap$PlatformMutabilityMapping(((JavaToKotlinClassMap)object).classId(Set.class), (ClassId)object2, (ClassId)object4);
        objectArray[4] = object3;
        object2 = ClassId.topLevel(StandardNames$FqNames.listIterator);
        Intrinsics.checkNotNullExpressionValue(object2, "topLevel(FqNames.listIterator)");
        object3 = StandardNames$FqNames.mutableListIterator;
        object4 = classId3;
        Object object14 = object3;
        Object object15 = object2;
        object3 = ((ClassId)object15).getPackageFqName();
        FqName fqName9 = ((ClassId)object15).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName9, "kotlinReadOnly.packageFqName");
        classId3 = new ClassId((FqName)object3, FqNamesUtilKt.tail((FqName)object14, fqName9), false);
        object3 = javaToKotlinClassMap$PlatformMutabilityMapping3;
        javaToKotlinClassMap$PlatformMutabilityMapping3 = new JavaToKotlinClassMap$PlatformMutabilityMapping(((JavaToKotlinClassMap)object).classId(ListIterator.class), (ClassId)object2, (ClassId)object4);
        objectArray[5] = object3;
        object2 = StandardNames$FqNames.map;
        object3 = ClassId.topLevel((FqName)object2);
        Intrinsics.checkNotNullExpressionValue(object3, "topLevel(FqNames.map)");
        object4 = StandardNames$FqNames.mutableMap;
        ClassId classId10 = classId2;
        Object object16 = object4;
        Object object17 = object3;
        object4 = ((ClassId)object17).getPackageFqName();
        FqName fqName10 = ((ClassId)object17).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName10, "kotlinReadOnly.packageFqName");
        classId2 = new ClassId((FqName)object4, FqNamesUtilKt.tail((FqName)object16, fqName10), false);
        object4 = javaToKotlinClassMap$PlatformMutabilityMapping2;
        javaToKotlinClassMap$PlatformMutabilityMapping2 = new JavaToKotlinClassMap$PlatformMutabilityMapping(((JavaToKotlinClassMap)object).classId(Map.class), (ClassId)object3, classId10);
        objectArray[6] = object4;
        object2 = ClassId.topLevel((FqName)object2).createNestedClassId(StandardNames$FqNames.mapEntry.shortName());
        Intrinsics.checkNotNullExpressionValue(object2, "topLevel(FqNames.map).cr\u2026mes.mapEntry.shortName())");
        object3 = StandardNames$FqNames.mutableMapEntry;
        object4 = classId;
        Object object18 = object3;
        Object object19 = object2;
        object3 = ((ClassId)object19).getPackageFqName();
        FqName fqName11 = ((ClassId)object19).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName11, "kotlinReadOnly.packageFqName");
        classId = new ClassId((FqName)object3, FqNamesUtilKt.tail((FqName)object18, fqName11), false);
        object3 = javaToKotlinClassMap$PlatformMutabilityMapping;
        javaToKotlinClassMap$PlatformMutabilityMapping = new JavaToKotlinClassMap$PlatformMutabilityMapping(((JavaToKotlinClassMap)object).classId(Map.Entry.class), (ClassId)object2, (ClassId)object4);
        objectArray[7] = object3;
        object2 = CollectionsKt.listOf(objectArray);
        JavaToKotlinClassMap javaToKotlinClassMap2 = object;
        mutabilityMappings = object2;
        javaToKotlinClassMap2.addTopLevel(Object.class, StandardNames$FqNames.any);
        javaToKotlinClassMap2.addTopLevel(String.class, StandardNames$FqNames.string);
        javaToKotlinClassMap2.addTopLevel(CharSequence.class, StandardNames$FqNames.charSequence);
        javaToKotlinClassMap2.addTopLevel(Throwable.class, StandardNames$FqNames.throwable);
        javaToKotlinClassMap2.addTopLevel(Cloneable.class, StandardNames$FqNames.cloneable);
        javaToKotlinClassMap2.addTopLevel(Number.class, StandardNames$FqNames.number);
        javaToKotlinClassMap2.addTopLevel(Comparable.class, StandardNames$FqNames.comparable);
        javaToKotlinClassMap2.addTopLevel(Enum.class, StandardNames$FqNames._enum);
        javaToKotlinClassMap2.addTopLevel(Annotation.class, StandardNames$FqNames.annotation);
        object = object2.iterator();
        while (object.hasNext()) {
            INSTANCE.addMapping((JavaToKotlinClassMap$PlatformMutabilityMapping)object.next());
        }
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            object4 = ClassId.topLevel(jvmPrimitiveType.getWrapperFqName());
            Intrinsics.checkNotNullExpressionValue(object4, "topLevel(jvmType.wrapperFqName)");
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)primitiveType, "jvmType.primitiveType");
            object4 = ClassId.topLevel(StandardNames.getPrimitiveFqName(primitiveType));
            Intrinsics.checkNotNullExpressionValue(object4, "topLevel(StandardNames.g\u2026e(jvmType.primitiveType))");
            INSTANCE.add((ClassId)object4, (ClassId)object4);
        }
        object = CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions().iterator();
        while (object.hasNext()) {
            ClassId classId11;
            ClassId classId12 = classId11 = (ClassId)object.next();
            classId11 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId11.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkNotNullExpressionValue(classId11, "topLevel(FqName(\"kotlin.\u2026g() + \"CompanionObject\"))");
            ClassId classId13 = classId12.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue(classId13, "classId.createNestedClas\u2026AME_FOR_COMPANION_OBJECT)");
            INSTANCE.add(classId11, classId13);
        }
        for (n = 0; n < 23; ++n) {
            JavaToKotlinClassMap javaToKotlinClassMap3 = INSTANCE;
            ClassId classId14 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + n));
            Intrinsics.checkNotNullExpressionValue(classId14, "topLevel(FqName(\"kotlin.\u2026m.functions.Function$i\"))");
            javaToKotlinClassMap3.add(classId14, StandardNames.getFunctionClassId(n));
            javaToKotlinClassMap3.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + n), K_FUNCTION_CLASS_ID);
        }
        for (n = 0; n < 22; ++n) {
            Object object20 = FunctionClassKind.KSuspendFunction;
            object20 = object20.getPackageFqName().toString() + '.' + object20.getClassNamePrefix();
            INSTANCE.addKotlinToJava(new FqName((String)object20 + n), K_FUNCTION_CLASS_ID);
        }
        JavaToKotlinClassMap javaToKotlinClassMap4 = INSTANCE;
        FqName fqName12 = StandardNames$FqNames.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName12, "nothing.toSafe()");
        javaToKotlinClassMap4.addKotlinToJava(fqName12, javaToKotlinClassMap4.classId(Void.class));
    }

    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    public final List getMutabilityMappings() {
        return mutabilityMappings;
    }

    public final ClassId mapJavaToKotlin(FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return (ClassId)javaToKotlin.get(fqName2.toUnsafe());
    }

    public final ClassId mapKotlinToJava(FqNameUnsafe fqNameUnsafe) {
        FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
        Intrinsics.checkNotNullParameter(fqNameUnsafe2, "kotlinFqName");
        return this.isKotlinFunctionWithBigArity(fqNameUnsafe2, NUMBERED_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_SUSPEND_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_K_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_K_SUSPEND_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : (ClassId)kotlinToJava.get(fqNameUnsafe))));
    }

    public final FqName mutableToReadOnly(FqNameUnsafe fqNameUnsafe) {
        return (FqName)mutableToReadOnly.get(fqNameUnsafe);
    }

    public final FqName readOnlyToMutable(FqNameUnsafe fqNameUnsafe) {
        return (FqName)readOnlyToMutable.get(fqNameUnsafe);
    }

    public final boolean isMutable(FqNameUnsafe fqNameUnsafe) {
        return mutableToReadOnly.containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(FqNameUnsafe fqNameUnsafe) {
        return readOnlyToMutable.containsKey(fqNameUnsafe);
    }
}

