/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class StandardNames {
    public static final StandardNames INSTANCE;
    public static final Name BACKING_FIELD;
    public static final Name DEFAULT_VALUE_PARAMETER;
    public static final Name ENUM_VALUES;
    public static final Name ENUM_VALUE_OF;
    public static final Name DATA_CLASS_COPY;
    public static final Name HASHCODE_NAME;
    public static final Name CHAR_CODE;
    public static final Name CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME;
    public static final FqName COROUTINES_PACKAGE_FQ_NAME;
    public static final FqName COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME;
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME;
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME;
    public static final FqName RESULT_FQ_NAME;
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    public static final List PREFIXES;
    public static final Name BUILT_INS_PACKAGE_NAME;
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    private static final FqName KOTLIN_INTERNAL_FQ_NAME;
    public static final Set BUILT_INS_PACKAGE_FQ_NAMES;

    private StandardNames() {
    }

    public static final String getFunctionName(int n) {
        return "Function" + n;
    }

    public static final ClassId getFunctionClassId(int n) {
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(StandardNames.getFunctionName(n)));
    }

    public static final String getSuspendFunctionName(int n) {
        return FunctionClassKind.SuspendFunction.getClassNamePrefix() + n;
    }

    public static final boolean isPrimitiveArray(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter(fqNameUnsafe, "arrayFqName");
        return StandardNames$FqNames.arrayClassFqNameToPrimitiveType.get(fqNameUnsafe) != null;
    }

    public static final FqName getPrimitiveFqName(PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)primitiveType, "primitiveType");
        FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
        Intrinsics.checkNotNullExpressionValue(fqName2, "BUILT_INS_PACKAGE_FQ_NAM\u2026d(primitiveType.typeName)");
        return fqName2;
    }

    static {
        FqName fqName2;
        FqName fqName3;
        INSTANCE = new StandardNames();
        Name name = Name.identifier("field");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"field\")");
        BACKING_FIELD = name;
        Name name2 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"value\")");
        DEFAULT_VALUE_PARAMETER = name2;
        Name name3 = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(\"values\")");
        ENUM_VALUES = name3;
        Name name4 = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(\"valueOf\")");
        ENUM_VALUE_OF = name4;
        Name name5 = Name.identifier("copy");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(\"copy\")");
        DATA_CLASS_COPY = name5;
        Name name6 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue(name6, "identifier(\"hashCode\")");
        HASHCODE_NAME = name6;
        Name name7 = Name.identifier("code");
        Intrinsics.checkNotNullExpressionValue(name7, "identifier(\"code\")");
        CHAR_CODE = name7;
        Name name8 = Name.identifier("count");
        Intrinsics.checkNotNullExpressionValue(name8, "identifier(\"count\")");
        CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME = name8;
        FqName fqName4 = fqName3;
        COROUTINES_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines");
        COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.jvm.internal");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.intrinsics");
        FqName fqName5 = fqName4.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue(fqName5, "COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"Continuation\"))");
        CONTINUATION_INTERFACE_FQ_NAME = fqName5;
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        FqName fqName6 = fqName2;
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        PREFIXES = CollectionsKt.listOf("KProperty", "KMutableProperty", "KFunction", "KSuspendFunction");
        Name name9 = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue(name9, "identifier(\"kotlin\")");
        BUILT_INS_PACKAGE_NAME = name9;
        FqName fqName7 = FqName.topLevel(name9);
        Intrinsics.checkNotNullExpressionValue(fqName7, "topLevel(BUILT_INS_PACKAGE_NAME)");
        BUILT_INS_PACKAGE_FQ_NAME = fqName7;
        FqName fqName8 = fqName7.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue(fqName8, "BUILT_INS_PACKAGE_FQ_NAM\u2026identifier(\"annotation\"))");
        ANNOTATION_PACKAGE_FQ_NAME = fqName8;
        FqName fqName9 = fqName7.child(Name.identifier("collections"));
        Intrinsics.checkNotNullExpressionValue(fqName9, "BUILT_INS_PACKAGE_FQ_NAM\u2026dentifier(\"collections\"))");
        COLLECTIONS_PACKAGE_FQ_NAME = fqName9;
        FqName fqName10 = fqName7.child(Name.identifier("ranges"));
        Intrinsics.checkNotNullExpressionValue(fqName10, "BUILT_INS_PACKAGE_FQ_NAM\u2026ame.identifier(\"ranges\"))");
        RANGES_PACKAGE_FQ_NAME = fqName10;
        FqName fqName11 = fqName7.child(Name.identifier("text"));
        Intrinsics.checkNotNullExpressionValue(fqName11, "BUILT_INS_PACKAGE_FQ_NAM\u2026(Name.identifier(\"text\"))");
        TEXT_PACKAGE_FQ_NAME = fqName11;
        FqName fqName12 = fqName7.child(Name.identifier("internal"));
        Intrinsics.checkNotNullExpressionValue(fqName12, "BUILT_INS_PACKAGE_FQ_NAM\u2026e.identifier(\"internal\"))");
        KOTLIN_INTERNAL_FQ_NAME = fqName12;
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf(fqName7, fqName9, fqName10, fqName8, fqName6, fqName12, fqName4);
    }
}

