/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.reflect;

import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.$Gson$Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class TypeToken<T> {
    final Class<? super T> rawType;
    final Type type;
    final int hashCode;

    protected TypeToken() {
        TypeToken typeToken = type2;
        Type type2 = TypeToken.getSuperclassTypeParameter(typeToken.getClass());
        typeToken.type = type2;
        typeToken.rawType = $Gson$Types.getRawType(type2);
        typeToken.hashCode = type2.hashCode();
    }

    TypeToken(Type type2) {
        TypeToken typeToken = type3;
        Type type3 = $Gson$Types.canonicalize((Type)$Gson$Preconditions.checkNotNull(type2));
        typeToken.type = type3;
        typeToken.rawType = $Gson$Types.getRawType(type3);
        typeToken.hashCode = type3.hashCode();
    }

    static Type getSuperclassTypeParameter(Class<?> type2) {
        if (!((type2 = type2.getGenericSuperclass()) instanceof Class)) {
            return $Gson$Types.canonicalize(((ParameterizedType)type2).getActualTypeArguments()[0]);
        }
        throw new RuntimeException("Missing type parameter.");
    }

    private static boolean isAssignableFrom(Type clazz, GenericArrayType type2) {
        if ((type2 = type2.getGenericComponentType()) instanceof ParameterizedType) {
            if (clazz instanceof GenericArrayType) {
                clazz = ((GenericArrayType)((Object)clazz)).getGenericComponentType();
            } else if (clazz instanceof Class) {
                clazz = clazz;
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
            }
            return TypeToken.isAssignableFrom(clazz, (ParameterizedType)type2, new HashMap<String, Type>());
        }
        return true;
    }

    private static boolean isAssignableFrom(Type object, ParameterizedType parameterizedType, Map<String, Type> map) {
        HashMap<String, Type> hashMap;
        if (object == null) {
            return false;
        }
        if (parameterizedType.equals(object)) {
            return true;
        }
        Class clazz = $Gson$Types.getRawType((Type)object);
        ParameterizedType parameterizedType2 = null;
        if (object instanceof ParameterizedType) {
            parameterizedType2 = (ParameterizedType)object;
        }
        if (parameterizedType2 != null) {
            object = parameterizedType2.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i = 0; i < ((Type[])object).length; ++i) {
                Type type2 = object[i];
                TypeVariable typeVariable = typeVariableArray[i];
                while (type2 instanceof TypeVariable) {
                    type2 = map.get(((TypeVariable)type2).getName());
                }
                map.put(typeVariable.getName(), type2);
            }
            if (TypeToken.typeEquals(parameterizedType2, parameterizedType, map)) {
                return true;
            }
        }
        object = clazz.getGenericInterfaces();
        int n = ((Type[])object).length;
        for (int i = 0; i < n; ++i) {
            HashMap<String, Type> hashMap2;
            HashMap<String, Type> hashMap3 = hashMap2;
            hashMap2 = new HashMap<String, Type>(map);
            if (!TypeToken.isAssignableFrom(object[i], parameterizedType, hashMap3)) continue;
            return true;
        }
        object = hashMap;
        hashMap = new HashMap<String, Type>(map);
        return TypeToken.isAssignableFrom(clazz.getGenericSuperclass(), parameterizedType, (Map<String, Type>)object);
    }

    private static boolean typeEquals(ParameterizedType typeArray, ParameterizedType typeArray2, Map<String, Type> map) {
        if (typeArray.getRawType().equals(typeArray2.getRawType())) {
            typeArray = typeArray.getActualTypeArguments();
            typeArray2 = typeArray2.getActualTypeArguments();
            for (int i = 0; i < typeArray.length; ++i) {
                if (TypeToken.matches(typeArray[i], typeArray2[i], map)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static AssertionError buildUnexpectedTypeError(Type type2, Class<?> ... classArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("Unexpected type. Expected one of: ");
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(classArray[i].getName()).append(", ");
        }
        stringBuilder2.append("but got: ").append(type2.getClass().getName()).append(", for type token: ").append(type2.toString()).append('.');
        return new AssertionError((Object)stringBuilder2.toString());
    }

    private static boolean matches(Type type2, Type type3, Map<String, Type> map) {
        return type3.equals(type2) || type2 instanceof TypeVariable && type3.equals(map.get(((TypeVariable)type2).getName()));
    }

    public static TypeToken<?> get(Type type2) {
        return new TypeToken(type2);
    }

    public static <T> TypeToken<T> get(Class<T> clazz) {
        return new TypeToken<T>(clazz);
    }

    public static TypeToken<?> getParameterized(Type type2, Type ... typeArray) {
        return new TypeToken($Gson$Types.newParameterizedTypeWithOwner(null, type2, typeArray));
    }

    public static TypeToken<?> getArray(Type type2) {
        return new TypeToken($Gson$Types.arrayOf(type2));
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    @Deprecated
    public boolean isAssignableFrom(Class<?> clazz) {
        return this.isAssignableFrom((Type)clazz);
    }

    @Deprecated
    public boolean isAssignableFrom(Type type2) {
        if (type2 == null) {
            return false;
        }
        if (this.type.equals(type2)) {
            return true;
        }
        Type type3 = this.type;
        if (type3 instanceof Class) {
            return this.rawType.isAssignableFrom($Gson$Types.getRawType(type2));
        }
        if (type3 instanceof ParameterizedType) {
            return TypeToken.isAssignableFrom(type2, (ParameterizedType)type3, new HashMap<String, Type>());
        }
        if (type3 instanceof GenericArrayType) {
            return this.rawType.isAssignableFrom($Gson$Types.getRawType(type2)) && TypeToken.isAssignableFrom(type2, (GenericArrayType)this.type);
        }
        throw TypeToken.buildUnexpectedTypeError(type3, Class.class, ParameterizedType.class, GenericArrayType.class);
    }

    @Deprecated
    public boolean isAssignableFrom(TypeToken<?> typeToken) {
        return this.isAssignableFrom(typeToken.getType());
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        return object instanceof TypeToken && $Gson$Types.equals(this.type, ((TypeToken)object).type);
    }

    public final String toString() {
        return $Gson$Types.typeToString(this.type);
    }
}

